/** @type {import('next').NextConfig} */
const nextConfig = {
  eslint: {
    ignoreDuringBuilds: true, // Disables ESLint during builds
  },
  typescript: {
    ignoreBuildErrors: true, // Disables TypeScript errors during builds
  },
  //Optional: Disable all build-time checks
  experimental: {
    forceSwcTransforms: true,
  },
  images: {
    unoptimized: true, // ✅ this is fine if you're not using next/image optimization
  },
};

module.exports = nextConfig;
