import { NextResponse } from 'next/server';
import { readdir } from 'fs/promises';
import { join } from 'path';

export async function GET() {
  try {
    const headersDir = join(process.cwd(), 'public', 'headers');
    const files = await readdir(headersDir);
    
    // Filter for image files
    const imageFiles = files.filter(file => 
      /\.(jpg|jpeg|png|gif|svg)$/i.test(file)
    );
    
    // Return file paths relative to public folder
    const headerImages = imageFiles.map(file => ({
      name: file,
      path: `/headers/${file}`,
      id: file.split('.')[0]
    }));
    
    return NextResponse.json(headerImages);
  } catch (error) {
    console.error('Error reading headers directory:', error);
    return NextResponse.json([], { status: 200 });
  }
}