import { NextResponse } from 'next/server';
import { readdir } from 'fs/promises';
import { join } from 'path';

export async function GET() {
  try {
    const footersDir = join(process.cwd(), 'public', 'footers');
    const files = await readdir(footersDir);
    
    // Filter for image files
    const imageFiles = files.filter(file => 
      /\.(jpg|jpeg|png|gif|svg)$/i.test(file)
    );
    
    // Return file paths relative to public folder
    const footerImages = imageFiles.map(file => ({
      name: file,
      path: `/footers/${file}`,
      id: file.split('.')[0]
    }));
    
    return NextResponse.json(footerImages);
  } catch (error) {
    console.error('Error reading footers directory:', error);
    return NextResponse.json([], { status: 200 });
  }
}